/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;

public class StandardFlowComparison
implements FlowComparison {
    private final ComparableDataFlow flowA;
    private final ComparableDataFlow flowB;
    private final Set<FlowDifference> differences;

    public StandardFlowComparison(ComparableDataFlow flowA, ComparableDataFlow flowB) {
        this.flowA = flowA;
        this.flowB = flowB;
        this.differences = new HashSet<FlowDifference>();
    }

    public StandardFlowComparison(ComparableDataFlow flowA, ComparableDataFlow flowB, Set<FlowDifference> differences) {
        this.flowA = flowA;
        this.flowB = flowB;
        this.differences = differences;
    }

    @Override
    public ComparableDataFlow getFlowA() {
        return this.flowA;
    }

    @Override
    public ComparableDataFlow getFlowB() {
        return this.flowB;
    }

    @Override
    public Set<FlowDifference> getDifferences() {
        return Collections.unmodifiableSet(this.differences);
    }

    public void addDifference(FlowDifference difference) {
        this.differences.add(difference);
    }
}

