/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.registration;

import com.fasterxml.jackson.databind.Module;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Supplier;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialCreationOptions;
import org.springframework.security.web.webauthn.jackson.WebauthnJackson2Module;
import org.springframework.security.web.webauthn.management.ImmutablePublicKeyCredentialCreationOptionsRequest;
import org.springframework.security.web.webauthn.management.WebAuthnRelyingPartyOperations;
import org.springframework.security.web.webauthn.registration.HttpSessionPublicKeyCredentialCreationOptionsRepository;
import org.springframework.security.web.webauthn.registration.PublicKeyCredentialCreationOptionsRepository;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class PublicKeyCredentialCreationOptionsFilter
extends OncePerRequestFilter {
    private PublicKeyCredentialCreationOptionsRepository repository = new HttpSessionPublicKeyCredentialCreationOptionsRepository();
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private RequestMatcher matcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, "/webauthn/register/options");
    private AuthorizationManager<HttpServletRequest> authorization = AuthenticatedAuthorizationManager.authenticated();
    private final WebAuthnRelyingPartyOperations rpOperations;
    private HttpMessageConverter<Object> converter = new MappingJackson2HttpMessageConverter(Jackson2ObjectMapperBuilder.json().modules(new Module[]{new WebauthnJackson2Module()}).build());

    public PublicKeyCredentialCreationOptionsFilter(WebAuthnRelyingPartyOperations rpOperations) {
        Assert.notNull((Object)rpOperations, (String)"rpOperations cannot be null");
        this.rpOperations = rpOperations;
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        Assert.notNull((Object)requestMatcher, (String)"requestMatcher cannot be null");
        this.matcher = requestMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.matcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Supplier context = this.securityContextHolderStrategy.getDeferredContext();
        Supplier<Authentication> authentication = () -> PublicKeyCredentialCreationOptionsFilter.lambda$doFilterInternal$0((Supplier)context);
        AuthorizationResult result = this.authorization.authorize(authentication, (Object)request);
        if (result == null || !result.isGranted()) {
            response.setStatus(400);
            return;
        }
        PublicKeyCredentialCreationOptions options = this.rpOperations.createPublicKeyCredentialCreationOptions(new ImmutablePublicKeyCredentialCreationOptionsRequest(authentication.get()));
        this.repository.save(request, response, options);
        response.setStatus(200);
        response.setHeader("Content-Type", "application/json");
        this.converter.write((Object)options, MediaType.APPLICATION_JSON, (HttpOutputMessage)new ServletServerHttpResponse(response));
    }

    public void setCreationOptionsRepository(PublicKeyCredentialCreationOptionsRepository creationOptionsRepository) {
        Assert.notNull((Object)creationOptionsRepository, (String)"creationOptionsRepository cannot be null");
        this.repository = creationOptionsRepository;
    }

    public void setConverter(HttpMessageConverter<Object> converter) {
        Assert.notNull(converter, (String)"converter cannot be null");
        this.converter = converter;
    }

    private static /* synthetic */ Authentication lambda$doFilterInternal$0(Supplier context) {
        return ((SecurityContext)context.get()).getAuthentication();
    }
}

