/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.security.torque.om.BaseTurbineUserPeer;
import org.apache.fulcrum.security.torque.om.TurbineUser;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;

public class BaseTurbineUserRecordMapper
implements RecordMapper<TurbineUser> {
    private static final long serialVersionUID = 1735909173315L;
    private static Log log = LogFactory.getLog(BaseTurbineUserRecordMapper.class);
    private static final String USER_ID_EXPRESSION = BaseTurbineUserPeer.USER_ID.getSqlExpression();
    private static final String LOGIN_NAME_EXPRESSION = BaseTurbineUserPeer.LOGIN_NAME.getSqlExpression();
    private static final String PASSWORD_VALUE_EXPRESSION = BaseTurbineUserPeer.PASSWORD_VALUE.getSqlExpression();
    private static final String FIRST_NAME_EXPRESSION = BaseTurbineUserPeer.FIRST_NAME.getSqlExpression();
    private static final String LAST_NAME_EXPRESSION = BaseTurbineUserPeer.LAST_NAME.getSqlExpression();
    private static final String EMAIL_EXPRESSION = BaseTurbineUserPeer.EMAIL.getSqlExpression();
    private static final String OBJECTDATA_EXPRESSION = BaseTurbineUserPeer.OBJECTDATA.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<TurbineUser> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TurbineUser processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        TurbineUser turbineUser = new TurbineUser();
        try {
            turbineUser.setLoading(true);
            if (criteria == null) {
                turbineUser.setEntityId(this.getEntityId(resultSet, offset + 1));
                turbineUser.setEntityName(this.getEntityName(resultSet, offset + 2));
                turbineUser.setPassword(this.getPassword(resultSet, offset + 3));
                turbineUser.setFirstName(this.getFirstName(resultSet, offset + 4));
                turbineUser.setLastName(this.getLastName(resultSet, offset + 5));
                turbineUser.setEmail(this.getEmail(resultSet, offset + 6));
                turbineUser.setObjectdata(this.getObjectdata(resultSet, offset + 7));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(USER_ID_EXPRESSION) && USER_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityId(this.getEntityId((ResultSet)res, nextOffset)));
                        } else {
                            turbineUser.setEntityId(this.getEntityId(resultSet, totalOffset));
                        }
                        columnsMapped.add(USER_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(LOGIN_NAME_EXPRESSION) && LOGIN_NAME_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEntityName(this.getEntityName((ResultSet)res, nextOffset)));
                        } else {
                            turbineUser.setEntityName(this.getEntityName(resultSet, totalOffset));
                        }
                        columnsMapped.add(LOGIN_NAME_EXPRESSION);
                    } else if (!columnsMapped.contains(PASSWORD_VALUE_EXPRESSION) && PASSWORD_VALUE_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setPassword(this.getPassword((ResultSet)res, nextOffset)));
                        } else {
                            turbineUser.setPassword(this.getPassword(resultSet, totalOffset));
                        }
                        columnsMapped.add(PASSWORD_VALUE_EXPRESSION);
                    } else if (!columnsMapped.contains(FIRST_NAME_EXPRESSION) && FIRST_NAME_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setFirstName(this.getFirstName((ResultSet)res, nextOffset)));
                        } else {
                            turbineUser.setFirstName(this.getFirstName(resultSet, totalOffset));
                        }
                        columnsMapped.add(FIRST_NAME_EXPRESSION);
                    } else if (!columnsMapped.contains(LAST_NAME_EXPRESSION) && LAST_NAME_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setLastName(this.getLastName((ResultSet)res, nextOffset)));
                        } else {
                            turbineUser.setLastName(this.getLastName(resultSet, totalOffset));
                        }
                        columnsMapped.add(LAST_NAME_EXPRESSION);
                    } else if (!columnsMapped.contains(EMAIL_EXPRESSION) && EMAIL_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEmail(this.getEmail((ResultSet)res, nextOffset)));
                        } else {
                            turbineUser.setEmail(this.getEmail(resultSet, totalOffset));
                        }
                        columnsMapped.add(EMAIL_EXPRESSION);
                    } else if (!columnsMapped.contains(OBJECTDATA_EXPRESSION) && OBJECTDATA_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setObjectdata(this.getObjectdata((ResultSet)res, nextOffset)));
                        } else {
                            turbineUser.setObjectdata(this.getObjectdata(resultSet, totalOffset));
                        }
                        columnsMapped.add(OBJECTDATA_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(7, true);
                    this.strategy.execute(resultSet, (Object)turbineUser);
                }
            }
            turbineUser.setNew(false);
            turbineUser.setModified(false);
        }
        finally {
            turbineUser.setLoading(false);
        }
        return turbineUser;
    }

    protected Integer getEntityId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEntityName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getPassword(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getFirstName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getLastName(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEmail(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected byte[] getObjectdata(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            byte[] value = resultSet.getBytes(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

