/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.turbine.entity.TurbinePermission;
import org.apache.fulcrum.security.torque.om.TorqueTurbinePermissionPeer;
import org.apache.fulcrum.security.torque.om.TorqueTurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TorqueTurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class FulcrumAbstractTurbinePermission
extends TorqueAbstractSecurityEntity
implements TurbinePermission {
    private static final long serialVersionUID = -5313324873688923207L;
    private Set<Role> roleSet = null;

    protected List<TorqueTurbineRolePermission> getTorqueTurbineRolePermissionsJoinTorqueTurbineRole(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueTurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
        return TorqueTurbineRolePermissionPeer.doSelectJoinTorqueTurbineRole(criteria, con);
    }

    public void addRole(Role role) {
        this.getRoles().add((SecurityEntity)role);
    }

    public RoleSet getRoles() {
        if (this.roleSet == null) {
            this.roleSet = new RoleSet();
        } else if (!(this.roleSet instanceof RoleSet)) {
            this.roleSet = new RoleSet(this.roleSet);
        }
        return (RoleSet)this.roleSet;
    }

    public <T extends Role> Set<T> getRolesAsSet() {
        return this.roleSet;
    }

    public void removeRole(Role role) {
        this.getRoles().remove((Object)role);
    }

    public void setRoles(RoleSet roleSet) {
        this.roleSet = roleSet != null ? roleSet : new RoleSet();
    }

    public <T extends Role> void setRolesAsSet(Set<T> roles) {
        this.setRoles(new RoleSet(roles));
    }

    public String getDatabaseName() {
        return TorqueTurbinePermissionPeer.DATABASE_NAME;
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        this.roleSet = new RoleSet();
        try {
            List<TorqueTurbineRolePermission> rolepermissions = this.getTorqueTurbineRolePermissionsJoinTorqueTurbineRole(new Criteria(), con);
            for (TorqueTurbineRolePermission ttrp : rolepermissions) {
                this.roleSet.add((Role)ttrp.getTorqueTurbineRole());
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(Connection con) throws TorqueException {
        if (this.roleSet != null) {
            Criteria criteria = new Criteria();
            criteria.where((Object)TorqueTurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
            TorqueTurbineRolePermissionPeer.doDelete(criteria, con);
            for (Role r : this.roleSet) {
                TorqueTurbineRolePermission rp = new TorqueTurbineRolePermission();
                rp.setRoleId((Integer)r.getId());
                rp.setPermissionId(this.getEntityId());
                rp.save(con);
            }
        }
        try {
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TorqueTurbinePermissionPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

