package org.apache.turbine.modules;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;

/**
 * This is the base class that defines what a Layout module is.
 *
 * @author <a href="mailto:mbryson@mont.mindspring.com">Dave Bryson</a>
 * @author <a href="mailto:peter@courcoux.biz">Peter Courcoux</a>
 * @version $Id: Layout.java 717934 2008-11-15 21:48:47Z tv $
 */
public abstract class Layout
    extends Assembler
{
    /** Prefix for layout related classes and templates */
    public static final String PREFIX = "layouts";
    
    /** Property for the size of the layout cache if caching is on */
    public static final String CACHE_SIZE_KEY = "layout.cache.size";
    
    /** The default size for the layout cache */
    public static final int CACHE_SIZE_DEFAULT = 10;

    /** Represents Layout Objects */
    public static final String NAME = "layout";

    /**
     * @see org.apache.turbine.modules.Assembler#getPrefix()
     */
    public String getPrefix()
    {
        return PREFIX;
    }

    /**
     * A subclass must override this method to build itself.
     * Subclasses override this method to store the layout in RunData
     * or to write the layout to the output stream referenced in
     * RunData.
     * @deprecated Use PipelineData version instead
     *
     * @param data Turbine information.
     * @exception Exception a generic exception.
     */
    protected abstract void doBuild(RunData data)
        throws Exception;

    /**
     * Subclasses can override this method to add additional
     * functionality.  This method is protected to force clients to
     * use LayoutLoader to build a Layout.
     * @deprecated Use PipelineData version instead
     * @param data Turbine information.
     * @exception Exception a generic exception.
     */
    protected void build(RunData data)
        throws Exception
    {
        doBuild(data);
    }


    /**
     * A subclass must override this method to perform itself.  The
     * Action can also set the screen that is associated with RunData.
     * Should revert to abstract when RunData is gone.
     * @param data Turbine information.
     * @exception Exception a generic exception.
     */
    protected void doBuild(PipelineData pipelineData) throws Exception
    {
        RunData data = getRunData(pipelineData);
        doBuild(data);
    }

    /**
     * Subclasses can override this method to add additional
     * functionality.  This method is protected to force clients to
     * use ActionLoader to perform an Action.
     *
     * @param data Turbine information.
     * @exception Exception a generic exception.
     */
    protected void build(PipelineData pipelineData) throws Exception
    {
        doBuild(pipelineData);
    }


}
