#<!-- Eurocopter EC 130 Helicopter by Heiko Schulz, animation set 
#This file is part of FlightGear, the free flight simulator
# http://www.flightgear.org/

#Copyright (C) Thorsten Renk
#modified by (C) 2021 Heiko Schulz, hhs_fgfs@web.de

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful, but
 #WITHOUT ANY WARRANTY; without even the implied warranty of
 #MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#-->

##########################################
##########################################
var rotorwash = maketimer(0.1, func(){

var vpos = geo.viewer_position();
var apos = geo.aircraft_position();

var lat_to_m = 110952.0;
var lon_to_m = math.cos(apos.lat()*math.pi/180.0) * lat_to_m;

var alt = getprop("/position/altitude-agl-ft");

var delta_x = (apos.lat() - vpos.lat()) * lat_to_m;
var delta_y = -(apos.lon() - vpos.lon()) * lon_to_m;

setprop("/environment/aircraft-effects/wash-x", delta_x);
setprop("/environment/aircraft-effects/wash-y", delta_y);

var rpm_factor = getprop("rotors/main/rpm")/386.0;

var blade_incidence1 = getprop("rotors/main/blade[0]/incidence-deg") or 0;
var blade_incidence2 = getprop("rotors/main/blade[1]/incidence-deg") or 0;
var blade_incidence3 = getprop("rotors/main/blade[2]/incidence-deg") or 0;

var blade_incidence_av = ((blade_incidence1 + blade_incidence2 + blade_incidence3 )/3);

var strength = 150/alt;
if (strength > 1.0) {strength = 1.0;}
strength = strength * (rpm_factor* (blade_incidence_av/17)) +0.1 ;

setprop("/environment/aircraft-effects/wash-strength", strength);
setprop("/rotors/main/blade-incidence", blade_incidence_av);

});
rotorwash.start();