/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.ext;

import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import gnu.crypto.pki.X500Name;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralNames {
    public static final int OTHER_NAME = 0;
    public static final int RFC822_NAME = 1;
    public static final int DNS_NAME = 2;
    public static final int X400_ADDRESS = 3;
    public static final int DIRECTORY_NAME = 4;
    public static final int EDI_PARTY_NAME = 5;
    public static final int URI = 6;
    public static final int IP_ADDRESS = 7;
    public static final int REGISTERED_ID = 8;
    private List names = new LinkedList();
    static /* synthetic */ Class class$gnu$crypto$pki$ext$GeneralNames;

    public List getNames() {
        ArrayList l = new ArrayList(this.names.size());
        Iterator it = this.names.iterator();
        while (it.hasNext()) {
            List ll = (List)it.next();
            ArrayList<Object> pair = new ArrayList<Object>(2);
            pair.add(ll.get(0));
            if (ll.get(1) instanceof byte[]) {
                pair.add(((byte[])ll.get(1)).clone());
            } else {
                pair.add(ll.get(1));
            }
            l.add(Collections.unmodifiableList(pair));
        }
        return Collections.unmodifiableList(l);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$crypto$pki$ext$GeneralNames;
        if (clazz == null) {
            clazz = class$gnu$crypto$pki$ext$GeneralNames = GeneralNames.class("[Lgnu.crypto.pki.ext.GeneralNames;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ ").append(this.names).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public GeneralNames(byte[] encoded) throws IOException {
        DERReader der = new DERReader(encoded);
        DERValue nameList = der.read();
        if (!nameList.isConstructed()) {
            throw new IOException("malformed GeneralNames");
        }
        int len = 0;
        while (len < nameList.getLength()) {
            DERValue name = der.read();
            ArrayList<Object> namePair = new ArrayList<Object>(2);
            if (name.getTagClass() != 64) {
                throw new IOException("malformed GeneralName");
            }
            namePair.add(new Integer(name.getTag()));
            Object val = null;
            switch (name.getTag()) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    namePair.add(new String((byte[])name.getValue()));
                    break;
                }
                case 0: 
                case 5: {
                    namePair.add(name.getValue());
                    break;
                }
                case 4: {
                    byte[] b = name.getEncoded();
                    b[0] = 48;
                    namePair.add(new X500Name(b).toString());
                    break;
                }
                case 7: {
                    namePair.add(InetAddress.getByAddress((byte[])name.getValue()).getHostAddress());
                    break;
                }
                case 8: {
                    byte[] bb = name.getEncoded();
                    bb[0] = 6;
                    namePair.add(new OID(bb).toString());
                    break;
                }
                default: {
                    throw new IOException("unknown tag " + name.getTag());
                }
            }
            this.names.add(namePair);
            len += name.getEncodedLength();
        }
    }
}

