
/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/// This file is generated by create-http-header-name-table, do not edit.

#ifndef HTTPHeaderNames_h
#define HTTPHeaderNames_h

#include <wtf/Forward.h>

namespace WebCore {

enum class HTTPHeaderName {
    Accept,
    AcceptCharset,
    AcceptEncoding,
    AcceptLanguage,
    AcceptRanges,
    AccessControlAllowCredentials,
    AccessControlAllowHeaders,
    AccessControlAllowMethods,
    AccessControlAllowOrigin,
    AccessControlExposeHeaders,
    AccessControlMaxAge,
    AccessControlRequestHeaders,
    AccessControlRequestMethod,
    Age,
    Authorization,
    CacheControl,
    Connection,
    ContentDisposition,
    ContentEncoding,
    ContentLanguage,
    ContentLength,
    ContentLocation,
    ContentRange,
    ContentSecurityPolicy,
    ContentSecurityPolicyReportOnly,
    ContentType,
    Cookie,
    Cookie2,
    CrossOriginResourcePolicy,
    DNT,
    Date,
    DefaultStyle,
    ETag,
    Expect,
    Expires,
    Host,
    IcyMetaInt,
    IcyMetadata,
    IfMatch,
    IfModifiedSince,
    IfNoneMatch,
    IfRange,
    IfUnmodifiedSince,
    KeepAlive,
    LastEventID,
    LastModified,
    Link,
    Location,
    Origin,
    PingFrom,
    PingTo,
    Pragma,
    ProxyAuthorization,
    Purpose,
    Range,
    Referer,
    ReferrerPolicy,
    Refresh,
    SecWebSocketAccept,
    SecWebSocketExtensions,
    SecWebSocketKey,
    SecWebSocketProtocol,
    SecWebSocketVersion,
    ServerTiming,
    ServiceWorker,
    ServiceWorkerAllowed,
    SetCookie,
    SetCookie2,
    SourceMap,
    TE,
    TimingAllowOrigin,
    Trailer,
    TransferEncoding,
    Upgrade,
    UpgradeInsecureRequests,
    UserAgent,
    Vary,
    Via,
    XContentTypeOptions,
    XDNSPrefetchControl,
    XFrameOptions,
    XSourceMap,
    XTempTablet,
    XXSSProtection,
};

const unsigned numHTTPHeaderNames = 84;
const size_t minHTTPHeaderNameLength = 2;
const size_t maxHTTPHeaderNameLength = 35;

bool findHTTPHeaderName(StringView, HTTPHeaderName&);
WEBCORE_EXPORT StringView httpHeaderNameString(HTTPHeaderName);

} // namespace WebCore

namespace WTF {

template<> struct EnumTraits<WebCore::HTTPHeaderName> {
    using values = EnumValues<
        WebCore::HTTPHeaderName,
        WebCore::HTTPHeaderName::Accept,
        WebCore::HTTPHeaderName::AcceptCharset,
        WebCore::HTTPHeaderName::AcceptEncoding,
        WebCore::HTTPHeaderName::AcceptLanguage,
        WebCore::HTTPHeaderName::AcceptRanges,
        WebCore::HTTPHeaderName::AccessControlAllowCredentials,
        WebCore::HTTPHeaderName::AccessControlAllowHeaders,
        WebCore::HTTPHeaderName::AccessControlAllowMethods,
        WebCore::HTTPHeaderName::AccessControlAllowOrigin,
        WebCore::HTTPHeaderName::AccessControlExposeHeaders,
        WebCore::HTTPHeaderName::AccessControlMaxAge,
        WebCore::HTTPHeaderName::AccessControlRequestHeaders,
        WebCore::HTTPHeaderName::AccessControlRequestMethod,
        WebCore::HTTPHeaderName::Age,
        WebCore::HTTPHeaderName::Authorization,
        WebCore::HTTPHeaderName::CacheControl,
        WebCore::HTTPHeaderName::Connection,
        WebCore::HTTPHeaderName::ContentDisposition,
        WebCore::HTTPHeaderName::ContentEncoding,
        WebCore::HTTPHeaderName::ContentLanguage,
        WebCore::HTTPHeaderName::ContentLength,
        WebCore::HTTPHeaderName::ContentLocation,
        WebCore::HTTPHeaderName::ContentRange,
        WebCore::HTTPHeaderName::ContentSecurityPolicy,
        WebCore::HTTPHeaderName::ContentSecurityPolicyReportOnly,
        WebCore::HTTPHeaderName::ContentType,
        WebCore::HTTPHeaderName::Cookie,
        WebCore::HTTPHeaderName::Cookie2,
        WebCore::HTTPHeaderName::CrossOriginResourcePolicy,
        WebCore::HTTPHeaderName::DNT,
        WebCore::HTTPHeaderName::Date,
        WebCore::HTTPHeaderName::DefaultStyle,
        WebCore::HTTPHeaderName::ETag,
        WebCore::HTTPHeaderName::Expect,
        WebCore::HTTPHeaderName::Expires,
        WebCore::HTTPHeaderName::Host,
        WebCore::HTTPHeaderName::IcyMetaInt,
        WebCore::HTTPHeaderName::IcyMetadata,
        WebCore::HTTPHeaderName::IfMatch,
        WebCore::HTTPHeaderName::IfModifiedSince,
        WebCore::HTTPHeaderName::IfNoneMatch,
        WebCore::HTTPHeaderName::IfRange,
        WebCore::HTTPHeaderName::IfUnmodifiedSince,
        WebCore::HTTPHeaderName::KeepAlive,
        WebCore::HTTPHeaderName::LastEventID,
        WebCore::HTTPHeaderName::LastModified,
        WebCore::HTTPHeaderName::Link,
        WebCore::HTTPHeaderName::Location,
        WebCore::HTTPHeaderName::Origin,
        WebCore::HTTPHeaderName::PingFrom,
        WebCore::HTTPHeaderName::PingTo,
        WebCore::HTTPHeaderName::Pragma,
        WebCore::HTTPHeaderName::ProxyAuthorization,
        WebCore::HTTPHeaderName::Purpose,
        WebCore::HTTPHeaderName::Range,
        WebCore::HTTPHeaderName::Referer,
        WebCore::HTTPHeaderName::ReferrerPolicy,
        WebCore::HTTPHeaderName::Refresh,
        WebCore::HTTPHeaderName::SecWebSocketAccept,
        WebCore::HTTPHeaderName::SecWebSocketExtensions,
        WebCore::HTTPHeaderName::SecWebSocketKey,
        WebCore::HTTPHeaderName::SecWebSocketProtocol,
        WebCore::HTTPHeaderName::SecWebSocketVersion,
        WebCore::HTTPHeaderName::ServerTiming,
        WebCore::HTTPHeaderName::ServiceWorker,
        WebCore::HTTPHeaderName::ServiceWorkerAllowed,
        WebCore::HTTPHeaderName::SetCookie,
        WebCore::HTTPHeaderName::SetCookie2,
        WebCore::HTTPHeaderName::SourceMap,
        WebCore::HTTPHeaderName::TE,
        WebCore::HTTPHeaderName::TimingAllowOrigin,
        WebCore::HTTPHeaderName::Trailer,
        WebCore::HTTPHeaderName::TransferEncoding,
        WebCore::HTTPHeaderName::Upgrade,
        WebCore::HTTPHeaderName::UpgradeInsecureRequests,
        WebCore::HTTPHeaderName::UserAgent,
        WebCore::HTTPHeaderName::Vary,
        WebCore::HTTPHeaderName::Via,
        WebCore::HTTPHeaderName::XContentTypeOptions,
        WebCore::HTTPHeaderName::XDNSPrefetchControl,
        WebCore::HTTPHeaderName::XFrameOptions,
        WebCore::HTTPHeaderName::XSourceMap,
        WebCore::HTTPHeaderName::XTempTablet,
        WebCore::HTTPHeaderName::XXSSProtection
    >;
};

} // namespace WTF

#endif // HTTPHeaderNames_h
